// --------------------------------------------------------------------
//
//  File:        create_e_and_pi.c
//  Date:        11/03
//  Last update: 11/03
//  Description: Create the irrational numbers e and pi
//
//  (C) 2003, Elisavet Konstantinou & Yiannis Stamatiu & Christos Zaroliagis
//                 {konstane,stamatiu,zaro}@ceid.upatras.gr
//
// --------------------------------------------------------------------


#include <gmp.h>
#include <stdio.h>
#include <stdlib.h>
#include "create_e_and_pi.h"


long num_of_digits = 161; /*precision required for the construction of the polynomial*/


/* creates e */
void create_e(mpf_t *e)
{
    long i;
    mpf_t s, s1, t;

    mpf_init(s);
    mpf_init(s1);
    mpf_init(t);

    mpf_set_ui(s, 1);
    mpf_set_ui(t, 1);


    for(i = 2; ; i++)
    {
	mpf_add(s1, s, t);

	if(mpf_cmp(s1, s) == 0) break;

	mpf_set(s, s1);
	mpf_div_ui(t, t, i);
    }

    mpf_set(*e, s);

    mpf_clear(s);
    mpf_clear(s1);
    mpf_clear(t);

}


/* creates pi */
void create_pi(mpf_t *pi)
{
    long i;
    mpf_t sum1, s, s1, t, t1, t25;
    mpf_t g;

    mpf_init(sum1);
    mpf_init(s);
    mpf_init(s1);
    mpf_init(t);
    mpf_init(t1);
    mpf_init(t25);
    mpf_init(g);

    mpf_set_ui(s, 0);
    mpf_set_str(t, "0.5e0", 10);
    mpf_set_str(t1, "0.5e0", 10);
    mpf_set_str(t25, "0.25e0", 10);

    mpf_neg(t25, t25);

    for(i = 3; ; i+=2)
    {
	mpf_add(s1, s, t);

	if(mpf_cmp(s1, s) == 0) break;

	mpf_set(s, s1);

	mpf_mul(t1, t1, t25);
	mpf_div_ui(t, t1, i);
    }

    mpf_set(sum1, s);

    mpf_set_ui(t25, 1);
    mpf_div_ui(g, t25, 3);

    mpf_set_ui(s, 0);
    mpf_set(t, g);
    mpf_set(t1, g);

    mpf_pow_ui(g, g, 2);
    mpf_neg(g, g);

    for(i = 3; ; i+=2)
    {
	mpf_add(s1, s, t);

	if(mpf_cmp(s1, s) == 0) break;

	mpf_set(s, s1);

	mpf_mul(t1, t1, g);
	mpf_div_ui(t, t1, i);
    }

    mpf_add(s, s, sum1);
    mpf_mul_ui(s, s, 4);

    mpf_set(*pi, s);


    mpf_clear(sum1);
    mpf_clear(s);
    mpf_clear(s1);
    mpf_clear(t);
    mpf_clear(t1);
    mpf_clear(t25);
    mpf_clear(g);

}
